#ifndef _OFX_POCO_DIRECTORY_LISTER
#define _OFX_POCO_DIRECTORY_LISTER

#define OF_USING_POCO
#include "ofMain.h"

#include "Poco/DirectoryIterator.h"
#include "Poco/Path.h"

using Poco::DirectoryIterator;
using Poco::Path;


class ofxPocoDirectoryLister
{
	public:
	ofxPocoDirectoryLister(); //constructeur
	~ofxPocoDirectoryLister(); //destructeur


	void setExtensionToLookFor(string extension)
	{
		extensionToLookFor = extension;
	}
	string getExtensionToLookFor()
	{
		return extensionToLookFor;
	}
	void setPath(Poco::Path _p)
	{
		currentPath = _p;
	}
	Poco::Path getCurrentPath()
	{
		return currentPath;
	}
	long getNumberOfFiles()
	{
		refreshFiles();
		return currentFiles.size();
	}

	void findSubDirectories( vector<string> & directories);
	void getFileNames( vector<string> & files );
	
	void listFiles(); //affiche tous les fichiers dans le chemin d'accès actuel, il ne doit être appelé après l'actualisation


	Poco::Path getPath(long l);
private:
	void refreshFiles(); //rafraîchit tous les fichiers dans le chemin actuel
	Poco::Path			currentPath;			//le chemin d'accès actuel du répertoire
	std::vector <Poco::Path>	currentFiles; //un vecteur contenant tous les fichiers dans le chemin courant
	string extensionToLookFor;		//une chaîne représentant l'extension que nous recherchons
};

#endif

